unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, AHMTColorPopup, AHMDialogClass;
type
  TForm1 = class(TForm)
    AHMColorPopup1: TAHMColorPopup;
    Button1: TButton;
    Panel1: TPanel;
    Label1: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    Label2: TLabel;
    Edit3: TEdit;
    Edit4: TEdit;
    Edit5: TEdit;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    RScroll: TScrollBar;
    GScroll: TScrollBar;
    BScroll: TScrollBar;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    Button2: TButton;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    CheckBox5: TCheckBox;
    Panel2: TPanel;
    Label6: TLabel;
    ComboBox1: TComboBox;
    CheckBox6: TCheckBox;
    CheckBox7: TCheckBox;
    procedure Button1Click(Sender: TObject);
    procedure Edit1Exit(Sender: TObject);
    procedure Edit2Exit(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure RScrollChange(Sender: TObject);
    procedure GScrollChange(Sender: TObject);
    procedure BScrollChange(Sender: TObject);
    procedure Edit3Exit(Sender: TObject);
    procedure Edit4Exit(Sender: TObject);
    procedure Edit5Exit(Sender: TObject);
    procedure Edit3KeyPress(Sender: TObject; var Key: Char);
    procedure Edit1KeyPress(Sender: TObject; var Key: Char);
    procedure Edit2KeyPress(Sender: TObject; var Key: Char);
    procedure CheckBox2Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure CheckBox4Click(Sender: TObject);
    procedure CheckBox3Click(Sender: TObject);
    procedure AHMColorPopup1ColorChange(Sender: TObject; OldColor,
      NewColor: TColor);
    procedure CheckBox5Click(Sender: TObject);
    procedure AHMColorPopup1SelectionChange(Sender: TObject; OldColor,
      NewColor: TColor);
    procedure ComboBox1Change(Sender: TObject);
    procedure CheckBox7Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
  AHMColorPopup1.DropDown(Button1);
end;

procedure TForm1.Edit1Exit(Sender: TObject);
begin
  try
    AHMColorPopup1.CurrentAsHtml:=Edit1.Text;
  except
    AHMColorPopup1ColorChange(Self,clNone,AHMColorPopup1.Current)
  end;
end;

procedure TForm1.Edit2Exit(Sender: TObject);
begin
  try
    AHMColorPopup1.CurrentAsHelp:=Edit2.Text;
  except
    AHMColorPopup1ColorChange(Self,clNone,AHMColorPopup1.Current)
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Combobox1.ItemIndex:=Integer(AHMColorPopup1.Options.Edges);
  AHMColorPopup1.Current:=clred;
  Checkbox6.Checked:=AHMColorPopup1.CustomBtn1.Visible;
  Checkbox7.Checked:=AHMColorPopup1.CustomBtn2.Visible;
  Checkbox5.Checked:=AHMColorPopup1.Options.Advanced;
  if not(Checkbox5.Checked) then Checkbox3.enabled:=False;
  Checkbox4.Checked:=AHMColorPopup1.AutoClose;
  Checkbox3.Checked:=AHMColorPopup1.More.Visible;
  Checkbox1.Checked:=AHMColorPopup1.Options.Selection=AdvancedColors;
  Checkbox2.Checked:=AHMColorPopup1.Options.SystemColors;
end;

procedure TForm1.RScrollChange(Sender: TObject);
begin
  with AHMColorPopup1 do
    CurrentAsRGB.RValue:=RScroll.Position;
end;

procedure TForm1.GScrollChange(Sender: TObject);
begin
  with AHMColorPopup1 do
    CurrentAsRGB.GValue:=GScroll.Position;
end;

procedure TForm1.BScrollChange(Sender: TObject);
begin
  with AHMColorPopup1 do
    CurrentAsRGB.BValue:=BScroll.Position;
end;

procedure TForm1.Edit3Exit(Sender: TObject);
begin
  try
    with AHMColorPopup1 do
      CurrentAsRGB.RValue:=StrToInt(Edit3.Text);
  except
    AHMColorPopup1ColorChange(Self,clNone,AHMColorPopup1.Current)
  end;
end;

procedure TForm1.Edit4Exit(Sender: TObject);
begin
  try
    with AHMColorPopup1 do
      CurrentAsRGB.GValue:=StrToInt(Edit4.Text);
  except
    AHMColorPopup1ColorChange(Self,clNone,AHMColorPopup1.Current)
  end;
end;

procedure TForm1.Edit5Exit(Sender: TObject);
begin
  try
    with AHMColorPopup1 do
      CurrentAsRGB.BValue:=StrToInt(Edit5.Text);
  except
    AHMColorPopup1ColorChange(Self,clNone,AHMColorPopup1.Current)
  end;
end;

procedure TForm1.Edit3KeyPress(Sender: TObject; var Key: Char);
const Avail='0123456789'+#8;
begin
  if Key=#27 then AHMColorPopup1ColorChange(Self,clNone,AHMColorPopup1.Current);
  if Pos(Key,Avail)=0 then Key:=#0;
end;

procedure TForm1.Edit1KeyPress(Sender: TObject; var Key: Char);
const Avail='0123456789ABCDEF#'+#8;
begin
  if Key=#27 then AHMColorPopup1ColorChange(Self,clNone,AHMColorPopup1.Current);
  if Pos(Key,Avail)=0 then Key:=#0;
end;

procedure TForm1.Edit2KeyPress(Sender: TObject; var Key: Char);
const Avail='r0123456789'+#8;
begin
  if Key=#27 then AHMColorPopup1ColorChange(Self,clNone,AHMColorPopup1.Current);
  if Pos(Key,Avail)=0 then Key:=#0;
end;

procedure TForm1.CheckBox2Click(Sender: TObject);
begin
  AHMColorPopup1.Options.SystemColors:=Checkbox2.Checked;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  case Checkbox1.Checked of
    True : AHMColorPopup1.Options.Selection:=AdvancedColors;
    False : AHMColorPopup1.Options.Selection:=BasicColors;
  end;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
// You can use this simple call:  AHMColorPopup1.Execute;
   AHMColorPopup1.Execute;
//  AHMColorPopup1.Popup(Self.Left+Self.Width,Self.Top);
end;

procedure TForm1.CheckBox4Click(Sender: TObject);
begin
  AHMColorPopup1.AutoClose:=Checkbox4.Checked;
end;

procedure TForm1.CheckBox3Click(Sender: TObject);
begin
 AHMColorPopup1.More.Visible:=Checkbox3.Checked;
end;

procedure TForm1.AHMColorPopup1ColorChange(Sender: TObject; OldColor,
  NewColor: TColor);
begin
  Panel1.Color:=NewColor;
  Panel2.Color:=NewColor;
  with AHMColorPopup1 do
  begin
    Edit1.Text:=CurrentAsHTML;
    Edit2.Text:=CurrentAsHelp;
    Edit3.Text:=inttostr(CurrentAsRGB.RValue);
    Edit4.Text:=inttostr(CurrentAsRGB.GValue);
    Edit5.Text:=inttostr(CurrentAsRGB.BValue);
    RScroll.Position:=CurrentAsRGB.RValue;
    GScroll.Position:=CurrentAsRGB.GValue;
    BScroll.Position:=CurrentAsRGB.BValue;
  end;
end;

procedure TForm1.CheckBox5Click(Sender: TObject);
begin
  AHMColorPopup1.Options.Advanced:=Checkbox5.Checked;
  if not(Checkbox5.Checked) then Checkbox3.enabled:=False
  else Checkbox3.enabled:=True;
end;

procedure TForm1.AHMColorPopup1SelectionChange(Sender: TObject; OldColor,
  NewColor: TColor);
begin
 Panel2.Color:=NewColor;
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
begin
 AHMColorPopup1.Options.Edges:=TAHMColorEdges(Combobox1.ItemIndex);
end;

procedure TForm1.CheckBox7Click(Sender: TObject);
begin
  with AHMColorPopup1 do
  begin
    CustomBtn1.Visible:=Checkbox6.Checked;
    CustomBtn2.Visible:=Checkbox7.Checked;
  end;
end;

end.
